import bge
import mathutils

MOUSE_SENSITIVITY = (0.001,0.001)
SPEED = 5
ACCELERATION = 20
JUMPFORCE = ACCELERATION * 25

KEYMAP = {'DKEY':(SPEED, 0, 0),
          'AKEY':(-SPEED, 0, 0),
          'WKEY':(0, SPEED, 0),
          'SKEY':(0, -SPEED, 0),
          'RIGHTARROWKEY':(SPEED, 0, 0),
          'LEFTARROWKEY':(-SPEED, 0, 0),
          'UPARROWKEY':(0, SPEED, 0),
          'DOWNARROWKEY':(0, -SPEED, 0),
          'SPACEKEY':(0,0,2),
          }
          
timer = 0
          
def every_frame(cont):
    '''This function is run every frame by the player object. It runs the movement and mouse-look functions.'''
    movement(cont)
    mouse(cont)
    hoverpad(cont)
    if 'init' not in cont.owner:
        cont.owner['init'] = 0
        create_constraints(cont)
        add_ball_light(cont)
    
    if timer >= 1:
        global timer
        timer -= 1
    print(timer)


def hoverpad(cont):
    ray_source = cont.owner.children['RayCheck']
    ray_direction = mathutils.Vector(ray_source.worldPosition[:]) + mathutils.Vector([0,0,-2])
    hit, _, _ = ray_source.rayCast(ray_source, ray_direction, 20, 'Hover', 0, 1)
    if hit != None:
        cont.owner.applyForce([0,0,75], False)


def add_ball_light(cont):
    '''Adds a lamp at the location of the object calling this script. This is due to a stupid limitation of libLoad'''
    lamp_object = bge.logic.getCurrentScene().objectsInactive['ball_light']
    new_lamp = bge.logic.getCurrentScene().addObject(lamp_object, cont.owner)
    new_lamp.setParent(cont.owner, True, True)

def create_constraints(cont):
    ball_manager = cont.owner
    camera_manager = [o for o in bge.logic.getCurrentScene().objects if 'camera_manager' in o][0]
    ball_graphics = [o for o in bge.logic.getCurrentScene().objects if 'ball_graphics' in o][0]

    #Link Camera_manager to ball_manager
    bge.constraints.createConstraint(camera_manager.getPhysicsId(), ball_manager.getPhysicsId(),
                             bge.constraints.POINTTOPOINT_CONSTRAINT,
                             0, 0, 0,
                             0, 0, 0)
    #And from the two ball parts
    bge.constraints.createConstraint(ball_graphics.getPhysicsId(), ball_manager.getPhysicsId(),
                             bge.constraints.POINTTOPOINT_CONSTRAINT,
                             0, 0, 0,
                             0, 0, 0)

    #Maximum Speed
    #cont.owner.linVelocityMax = 7
        

def movement(cont):
    '''Quite simply, it moves the player!!!'''
    motion_act = cont.actuators['Motion']
    motion_act.forceLimitX = -ACCELERATION, ACCELERATION, True
    motion_act.forceLimitY = -ACCELERATION, ACCELERATION, True
    motion_act.forceLimitZ = 0, ACCELERATION, True
    
    active_keys = get_active_keys()
    linV = mathutils.Vector([0,0,0])
    for key in active_keys:
        if KEYMAP[key][2] == 0:
            linV += mathutils.Vector(KEYMAP[key])
        else:
            jump(cont)
    
    motion_act.linV = linV
    cont.activate(motion_act)

def jump(cont):
    '''Jumps'''
    ray = cont.sensors['Ray']
    if ray.hitObject != None and str(ray.hitObject) != 'Camera Manager' and timer == 0:
    #if hit != 'Camera Manager' and hit != None:
        cont.owner.applyForce([0,0,JUMPFORCE])
        global timer
        timer = 10
        

def get_active_keys():
    '''Returns a list of the currently active keys on the keyboard'''
    currently_active = []
    for key in KEYMAP:
        key_id = bge.events.__dict__[key]
        status = bge.logic.keyboard.events[key_id]
        if status == bge.logic.KX_SENSOR_ACTIVE:
            currently_active.append(key)
    return currently_active
    

def mouse(cont):
    '''Rotates an object based on mouse movement'''
    mouse = cont.sensors['Mouse']
    x = (bge.render.getWindowWidth() / 2 - mouse.position[0]) * MOUSE_SENSITIVITY[0]
    y = (bge.render.getWindowHeight() / 2 - mouse.position[1]) * MOUSE_SENSITIVITY[1]

    x = round(x, 2)
    y = round(y, 2)

    #Left and Right
    left_right_object = cont.owner
    current_side_rot = left_right_object.worldOrientation.to_euler()
    left_right_object.worldOrientation = [0, 0, current_side_rot[2] + x]
    
    
    #Up and Down
    up_down_object = [o for o in bge.logic.getCurrentScene().objects if 'camera_manager' in o][0]
    current_rot = up_down_object.localOrientation.to_euler()
    up_down_object.localOrientation = [current_rot[0] + y, 0,current_side_rot[2] + x]

    #Zoom
    camera = bge.logic.getCurrentScene().active_camera
    distance = camera.getDistanceTo(cont.owner)
    curEvents = bge.logic.mouse.active_events
    for event in curEvents:
        if event == bge.events.WHEELUPMOUSE and distance > 1.5:
            camera.applyMovement([0,0,-distance/10],1)
        if event == bge.events.WHEELDOWNMOUSE and distance < 10:
            camera.applyMovement([0,0,distance/10],1)
    if str(camera.rayCastTo([o for o in bge.logic.getCurrentScene().objects if 'ball_graphics' in o][0])) != 'Ball Graphics':
        camera.applyMovement([0,0,-distance/10],1)
    elif distance < 1:
        camera.applyMovement([0,0,+0.3],1)
    elif distance > 100:
        camera.applyMovement([0,0,-0.05],1)
    
    
    #Reset Mouse Position
    bge.render.setMousePosition(int(bge.render.getWindowWidth() / 2), int(bge.render.getWindowHeight() / 2))
   
